% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_predictions_test.R
\name{compare_predictions_test}
\alias{compare_predictions_test}
\title{KS Test for Difference in Predictive Performance}
\usage{
compare_predictions_test(compare_predictions_out = NULL, alpha_level = 0.05)
}
\arguments{
\item{compare_predictions_out}{Matrix of correctly predicted ties produced by the \code{compare_predictions} function.}

\item{alpha_level}{The significance level that should be used for the test.}
}
\value{
Returns \code{ks.test} output to determine if the percent of correctly predicted ERGM ties are less than those of the FERGM and prints a message to assist with interpretation
}
\description{
This is a plot function to determine whether the distributions of predictions from ERGM and FERGM objects differ.  It does so by using a Kolmogorov-Smirnov Test.
}
\examples{
# load example data
data("ergm.fit")
data("fergm.fit")
data("mesa")
# Use built in compare_predictions function to compare predictions of ERGM and FERGM,
# few replications due to example
 net <- ergm.fit$network
predict_out <- compare_predictions(ergm.fit = ergm.fit, fergm.fit = fergm.fit,
                                   replications = 10, seed = 12345)

# We can also conduct a KS test to determine if the FERGM fit it statistically
 # distinguishable from the ERGM fit
compare_predictions_test(predict_out)
}
\keyword{Fit}
\keyword{GOF}
\keyword{KS}
\keyword{Kolmogorov-Smirnov}
\keyword{Prediction}
\keyword{Test}
