% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_space.R
\name{explore_space_pca}
\alias{explore_space_pca}
\alias{flip_sign}
\alias{compute_pca}
\title{Plot the PCA projection of the projection bases space}
\usage{
explore_space_pca(
  dt,
  details = FALSE,
  pca = TRUE,
  group = NULL,
  color = NULL,
  ...,
  animate = FALSE
)

flip_sign(dt, group = NULL, ...)

compute_pca(dt, group = NULL, random = TRUE, flip = TRUE, ...)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in \code{tourr}}

\item{details}{logical; if components other than start, end and interpolation need to be shown}

\item{pca}{logical; if PCA coordinates need to be computed for the data}

\item{group}{the variable to label different runs of the optimiser(s)}

\item{color}{the variable to be coloured by}

\item{...}{other arguments received from \code{explore_space_pca()}}

\item{animate}{logical; if the interpolation path needs to be animated}

\item{random}{logical; if random bases from the basis space need to be added to the data}

\item{flip}{logical; if the sign flipping need to be performed}
}
\value{
\describe{
  \item{\code{explore_space_pca()}}{a ggplot object for diagnosing the optimisers in the PCA-projected basis space}
  \item{\code{flip_sign()}}{a list containing
    \itemize{
        \item{a matrix of all the bases}
        \item{a logical value whether a flip of sign is performed}
        \item{a dataframe of the original dataset}}
     }
  \item{\code{compute_pca()}}{a list containing
    \itemize{
        \item{the PCA summary}
        \item{a dataframe with PC coordinates augmented}
     }}
}
}
\description{
The set of functions returns a primary ggplot object
that plots the data object in a space reduced by PCA.
\code{compute_pca()} computes the PCA and \code{explore_space_pca()} plots the bases in the PCA-projected space
}
\examples{
dplyr::bind_rows(holes_1d_geo, holes_1d_better) \%>\%
  bind_theoretical(matrix(c(0, 1, 0, 0, 0), nrow = 5),
    index = tourr::holes(), raw_data = boa5
  ) \%>\%
  explore_space_pca(group = method, details = TRUE) +
  scale_color_discrete_botanical()
dplyr::bind_rows(holes_1d_geo, holes_1d_better) \%>\%
  flip_sign(group = method) \%>\%
  str(max = 1)
dplyr::bind_rows(holes_1d_geo, holes_1d_better) \%>\% compute_pca(group = method)
}
\seealso{
Other main plot functions: 
\code{\link{explore_space_tour}()},
\code{\link{explore_trace_interp}()},
\code{\link{explore_trace_search}()}
}
\concept{main plot functions}
