% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_space.R
\name{explore_space_tour}
\alias{explore_space_tour}
\alias{prep_space_tour}
\title{Plot the grand tour animation of the bases space in high dimension}
\usage{
explore_space_tour(...)

prep_space_tour(
  dt,
  group = NULL,
  flip = FALSE,
  color = NULL,
  rand_size = 1,
  point_size = 1.5,
  end_size = 5,
  theo_size = 3,
  theo_shape = 17,
  theo_color = "black",
  palette = botanical_palettes$fern,
  ...
)
}
\arguments{
\item{...}{other argument passed to \code{tourr::animate_xy()} and \code{prep_space_tour()}}

\item{dt}{a data object collected by the projection pursuit guided tour optimisation in \code{tourr}}

\item{group}{the variable to label different runs of the optimiser(s)}

\item{flip}{logical; if the sign flipping need to be performed}

\item{color}{the variable to be coloured by}

\item{rand_size}{numeric; the size of random points}

\item{point_size}{numeric; the size of points searched by the optimiser(s)}

\item{end_size}{numeric; the size of end points}

\item{theo_size}{numeric; the size of theoretical point(s)}

\item{theo_shape}{numeric; the shape symbol in the basic plot}

\item{theo_color}{character; the color of theoretical point(s)}

\item{palette}{the colour palette to be used}
}
\value{
\describe{
  \item{\code{explore_space_tour()}}{an animation of the search path in the high-dimensional sphere}
  \item{\code{prep_space_tour()}}{a list containing various components needed for producing the animation}
}
}
\description{
Plot the grand tour animation of the bases space in high dimension
}
\examples{
explore_space_tour(dplyr::bind_rows(holes_1d_better, holes_1d_geo),
  group = method, palette = botanical_palettes$fern[c(1, 6)]
)
}
\seealso{
Other main plot functions: 
\code{\link{explore_space_pca}()},
\code{\link{explore_trace_interp}()},
\code{\link{explore_trace_search}()}
}
\concept{main plot functions}
