% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/framework-eda.R
\name{framework_eda}
\alias{framework_eda}
\title{Orchestrate Exploratory Data Analysis}
\usage{
framework_eda(
  data,
  years,
  ns_splits = NULL,
  generate_report = TRUE,
  report_path = NULL,
  report_formats = "html",
  ...
)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{years}{Numeric vector of observation years corresponding to \code{data}.
Must be the same length as \code{data} and strictly increasing.}

\item{ns_splits}{An integer vector of years used to split the data into homogeneous
subperiods. For S-FFA, set to \code{NULL} (default). For NS-FFA, specify an \emph{integer} vector
of years with physical justification for change points, or \code{NULL} if no such years exist.
In R, integers have the suffix \code{L}, so \code{1950L} is a valid input to \code{ns_splits}, but \code{1950}
is not (since R may interpret it as a floating point number).}

\item{generate_report}{If \code{TRUE} (default), generate a report.}

\item{report_path}{A character scalar, the file path for the generated report.
If \code{NULL} (default), the report will be saved to a new temporary directory.}

\item{report_formats}{A character vector specifying the output format for the
report. Supported values are \code{"md"}, \code{"pdf"}, \code{"html"}, and \code{"json"}.}

\item{...}{Additional arguments. See the "Optional Arguments" section for a
complete list.}
}
\value{
\code{eda_recommendations}: A list containing the recommended FFA approach, split
point(s) and nonstationary structure(s) from EDA:
\itemize{
\item \code{approach}: Either "S-FFA", "NS-FFA" (for a single homogeneous period), or
"Piecewise NS-FFA" (for multiple homogeneous subperiods).
\item \code{ns_splits}: The split point(s) identified by the change point detection test with
the the lowest statistically significant p-value, or \code{NULL} if no such point exists.
\item \code{ns_structures}: A list of structure objects for each homogeneous subperiod. Each
structure is a list with boolean items \code{location} and \code{scale}, which represent a
linear trend in the in the mean or variability of the data, respectively. If no
trends were found in any homogeneous subperiod, \code{ns_structures} will be \code{NULL}.
}

\code{submodule_results}: A list of lists of statistical tests. Each list contains:
\itemize{
\item \code{name}: Either "Change Point Detection" or "Trend Detection".
\item \code{start}: The first year of the homogeneous subperiod.
\item \code{end}: The last year of the homogeneous subperiod.
\item Additional items from the statistical tests within the submodule.
}
}
\description{
First, this method identifies change points in the original annual maximum series
data. Then, the user is given the option to split the dataset into two or more
homogenous subperiods (trend-free or with monotonic trends). Finally, this method
performs a collection of statistical tests for identifying monotonic nonstationarity
in the mean and variability of each subperiod (if the dataset was split) or of the
entire dataset (if it was not split). The results of EDA can help guide FFA approach
selection (stationary or nonstationary) and FFA model determination.
}
\section{Optional Arguments}{

\itemize{
\item \code{alpha}: The numeric significance level for all statistical tests (default is 0.05).
\item \code{bbmk_samples}: The number of samples used in the Block-Bootstrap Mann-Kendall
(BBMK) test (default is 10000). Must be an integer.
\item \code{window_size}: The size of the window used to compute the variability series.
\item \code{window_step}: The number of years between successive moving windows. Used to
compute the variability series.
}
}

\seealso{
\code{\link[=eda_pettitt_test]{eda_pettitt_test()}}, \code{\link[=eda_mks_test]{eda_mks_test()}}, \code{\link[=eda_mk_test]{eda_mk_test()}},
\code{\link[=eda_spearman_test]{eda_spearman_test()}}, \code{\link[=eda_bbmk_test]{eda_bbmk_test()}}, \code{\link[=eda_pp_test]{eda_pp_test()}}, \code{\link[=eda_kpss_test]{eda_kpss_test()}},
\code{\link[=eda_sens_trend]{eda_sens_trend()}}, \code{\link[=eda_runs_test]{eda_runs_test()}}, \code{\link[=eda_white_test]{eda_white_test()}}
}
