% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.R
\name{with.ffdf}
\alias{with.ffdf}
\title{Evaluate an expression in a ffdf data environment}
\usage{
\method{with}{ffdf}(data, expr, ...)
}
\arguments{
\item{data}{\code{\link{ffdf}} data object used as an environment for evaluation.}

\item{expr}{expression to evaluate.}

\item{...}{arguments to be passed to \code{\link{chunk}}.}
}
\value{
if expression is a \code{vector} a newly created \code{ff} vector will be returned 
otherwise if the expression is a data.frame a newly created \code{ffdf} object will be returned.
}
\description{
Evaluate an R expression in an environment constructed from a ffdf data frame.
(see \code{\link{with}}). Please note that you should write
your expression as if it is a normal \code{data.frame}. The resulting return value
however will be a \code{ff} object.
}
\note{
`with.ffdf` assumes that the returned object is of equal length as 
`nrow(data)` and must be converted to a `ff` object
In case this is not true, the result won't be correct.
}
\examples{
dat <- data.frame(x=1:10, y=10:1)

ffdat <- as.ffdf(dat)

with(ffdat, {x+y})
}
\seealso{
\code{\link{ffdfwith}}
}

