% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ffmanova.R
\name{predict.ffmanova}
\alias{predict.ffmanova}
\title{Predictions, mean predictions, adjusted means and linear combinations}
\usage{
\method{predict}{ffmanova}(object, newdata = NULL, linComb = NULL, nonEstimableAsNA = TRUE, ...)
}
\arguments{
\item{object}{Output from \code{\link{ffmanova}}.}

\item{newdata}{Data frame or list. Missing values and missing variables are possible.}

\item{linComb}{A matrix defining linear combinations.}

\item{nonEstimableAsNA}{When TRUE missing values are retuned when predictions cannot be made.
When FALSE predictions are made anyway, but the logical vector, \code{estimable}, 
is added to output in cases of non-estimable results.}

\item{...}{further arguments (not used)}
}
\value{
A list of two matrices:
\item{YnewPred}{Predictions, mean predictions, adjusted means or linear combinations of such predictions.}
\item{YnewStd}{Corresponding standard errors.}
}
\description{
The same predictions as \code{\link{lm}} can be obtained. With some variables missing in input, 
adjusted means or mean predictions are computed (Langsrud et al., 2007). 
Linear combinations of such predictions, with standard errors, 
can also be obtained.
}
\examples{
# Generate data
x1 <- 1:6
x2 <- rep(c(100, 200), each = 3)
y1 <- x1 + rnorm(6)/10
y2 <- y1 + x2 + rnorm(6)/10

# Create ffmanova object
ff <- ffmanova(cbind(y1, y2) ~ x1 + x2)

# Predictions from the input data
predict(ff)

# Rows 1 and 5 from above predictions
predict(ff, data.frame(x1 = c(1, 5), x2 = c(100, 200)))

# Rows 1 as above and row 2 different
predict(ff, data.frame(x1 = c(1, 5), x2 = 100))

# Three ways of making the same mean predictions
predict(ff, data.frame(x1 = c(1, 5), x2 = 150))
predict(ff, data.frame(x1 = c(1, 5), x2 = NA))
predict(ff, data.frame(x1 = c(1, 5)))

# Using linComb input specified to produce regression coefficients 
# with std. As produced by summary(lm(cbind(y1, y2) ~ x1 + x2))
predict(ff, data.frame(x1 = c(1, 2)), matrix(c(-1, 1), 1, 2))
predict(ff, data.frame(x2 = c(101, 102)), matrix(c(-1, 1), 1, 2))

# Above results by a 2*4 linComb matrix and with rownames
lC <- t(matrix(c(-1, 1, 0, 0, 0, 0, -1, 1), 4, 2))
rownames(lC) <- c("x1", "x2")
predict(ff, data.frame(x1 = c(1, 2, 1, 1), x2 = c(100, 100, 101, 102)), lC)
}
\references{
Langsrud, Ø., Jørgensen, K., Ofstad, R. and Næs, T. (2007):
 \dQuote{Analyzing Designed Experiments with Multiple Responses},
 \emph{Journal of Applied Statistics}, \bold{34}, 1275-1296.
}
