% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_ff_simulate.R
\name{ff_simulate}
\alias{ff_simulate}
\title{Simulate Fantasy Seasons}
\usage{
ff_simulate(
  conn,
  n_seasons = 100,
  n_weeks = 14,
  best_ball = FALSE,
  seed = NULL,
  gp_model = c("simple", "none"),
  base_seasons = 2012:2020,
  actual_schedule = FALSE,
  pos_filter = c("QB", "RB", "WR", "TE", "K"),
  verbose = getOption("ffsimulator.verbose", default = TRUE)
)
}
\arguments{
\item{conn}{an connection to a league made with \code{ff_connect()} and friends (required)}

\item{n_seasons}{number of seasons to simulate, default = 100}

\item{n_weeks}{number of weeks per season, default = 14}

\item{best_ball}{a logical: are weekly wins based on optimal lineups?}

\item{seed}{an integer to control reproducibility}

\item{gp_model}{select between "simple", "none" to apply a model for whether a player played in a given game, defaults to "simple"}

\item{base_seasons}{a numeric vector that selects seasons as base data, earliest available is 2012}

\item{actual_schedule}{a logical: use actual ff_schedule? default is FALSE}

\item{pos_filter}{a character vector of positions to filter/run, default is c("QB","RB","WR","TE","K")}

\item{verbose}{a logical: print status messages? default is TRUE, configure with options(ffsimulator.verbose)}
}
\value{
an \code{ff_simulation} object which can be passed to \code{plot()} and contains the output data from the simulation.
}
\description{
The main function of the package - uses bootstrap resampling to run fantasy football season simulations supported by historical rankings and nflfastR data, calculating optimal lineups, and returns aggregated results.
}
\examples{
\donttest{
conn <- mfl_connect(2021, 22627)
ff_simulate(conn, n_seasons = 25)
}

}
\seealso{
\code{vignette("basic")} for example usage

\code{vignette("custom")} for examples on using the subfunctions for your own processes.
}
