% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgeo_help.R
\name{fgeo_help}
\alias{fgeo_help}
\title{Get help with fgeo.}
\usage{
fgeo_help(pattern = "", package = NULL, rebuild = TRUE, ...)
}
\arguments{
\item{pattern}{A character string to be matched in the name, alias or title
of a topic's documentation. Defaults to matching everything, which
retrieves all the documentation of \strong{fgeo} packages.}

\item{package}{A character string giving the name of one or more
packages to limit the search, or \code{NULL} to search all fgeo packages.}

\item{rebuild}{a logical indicating whether the help database should
    be rebuilt.  This will be done automatically if \code{lib.loc} or
    the search path is changed, or if \code{package} is used and a value
    is not found.}

\item{...}{Other arguments passed to \code{\link[utils:help.search]{utils::help.search()}}.}
}
\value{
The results are returned in a list object of class "hsearch", which
has a print method for nicely formatting the results of the query.
}
\description{
\code{\link[=fgeo_help]{fgeo_help()}} finds all \strong{fgeo} help files. You can refine
your search directly on the viewer panel of RStudio or via a string passed
as the first argument to \code{\link[=fgeo_help]{fgeo_help()}}.
}
\examples{
if (interactive()) {
  fgeo_help()
}

dplyr::as_tibble(fgeo_help()$matches)

if (interactive()) {
  fgeo_help("stem", package = "fgeo.x")
}
}
\seealso{
\code{\link[utils:help.search]{utils::help.search()}}.

Other functions to explore fgeo: \code{\link{fgeo_browse}},
  \code{\link{fgeo_packages}}
}
\concept{functions to explore fgeo}
