% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{fwhich}
\alias{fwhich}
\alias{fwhich.default}
\alias{fwhich.FileArray}
\title{A generic function of \code{which} that is \code{'FileArray'} compatible}
\usage{
fwhich(x, val, arr.ind = FALSE, ...)

\method{fwhich}{default}(x, val, arr.ind = FALSE, ...)

\method{fwhich}{FileArray}(x, val, arr.ind = FALSE, ...)
}
\arguments{
\item{x}{any R vector, matrix, array or file-array}

\item{val}{values to find}

\item{arr.ind}{logical; should array indices be 
returned when \code{x} is an array?}

\item{...}{further passed to \code{\link{which}} or
\code{\link{arrayInd}}}
}
\value{
The indices of \code{x} elements that are listed in \code{val}.
}
\description{
A generic function of \code{which} that is \code{'FileArray'} compatible
}
\examples{


# Default case
x <- array(1:27, rep(3,3))
fwhich(x, c(4,5))

# file-array case
arr <- filearray_create(tempfile(), dim(x))
arr[] <- x
fwhich(arr, c(4,5))


}
