% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_KNNimpute.R
\name{fill.KNNimpute}
\alias{fill.KNNimpute}
\title{Imputation using Weighted K-nearest Neighbors}
\usage{
fill.KNNimpute(A, k = ceiling(nrow(A)/2))
}
\arguments{
\item{A}{an \eqn{(n\times p)} partially observed matrix.}

\item{k}{the number of neighbors to use.}
}
\value{
a named list containing \describe{
\item{X}{an \eqn{(n\times p)} matrix after completion.}
}
}
\description{
One of the simplest idea to \emph{guess} missing entry is to use
portion of the data that has most similar characteristics across
all covariates. \code{fill.KNNimpute} follows such reasoning in that
it finds \eqn{K}-nearest neighbors based on observed variables and
uses weighted average of nearest elements to fill in the missing entry.
Note that when there are many missing entries, it's possible that there are
no \emph{surrogates} to be computed upon. Therefore, if there exists an entire
row or column full of missing entries, the algorithm stops.
}
\examples{
## load image data of 'lena128'
data(lena128)

## transform 5\% of entries into missing
set.seed(5)
A <- aux.rndmissing(lena128, x=0.05)

## apply the method with 3 different neighborhood size
fill1 <- fill.KNNimpute(A, k=5)
fill2 <- fill.KNNimpute(A, k=25)
fill3 <- fill.KNNimpute(A, k=50)

## visualize only the last ones from each run
par(mfrow=c(2,2), pty="s")
image(A, col=gray((0:100)/100), axes=FALSE, main="5\% missing")
image(fill1$X, col=gray((0:100)/100), axes=FALSE, main="5-neighbor")
image(fill2$X, col=gray((0:100)/100), axes=FALSE, main="25-neighbor")
image(fill3$X, col=gray((0:100)/100), axes=FALSE, main="50-neighbor")

}
\references{
\insertRef{troyanskaya_missing_2001}{filling}
}
\seealso{
\code{\link{fill.SVDimpute}}
}
