% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmmixed.R
\name{lmmixed}
\alias{lmmixed}
\title{Mixed effects linear regression models: \code{finalfit} model wrapper}
\usage{
lmmixed(.data, dependent, explanatory, random_effect)
}
\arguments{
\item{.data}{Dataframe.}

\item{dependent}{Character vector of length 1, name of depdendent variable (must be continuous vector).}

\item{explanatory}{Character vector of any length: name(s) of explanatory variables.}

\item{random_effect}{Character vector of length 1, name of random effect variable.}
}
\value{
A list of multivariable \code{lme4::\link[lme4]{lmer}} fitted model outputs.
  Output is of class \code{lmerMod}.
}
\description{
Using \code{finalfit} conventions, produces mixed effects linear
  regression models for a set of explanatory variables against a continuous dependent.
}
\details{
Uses \code{lme4::\link[lme4]{lmer}} with \code{finalfit} modelling conventions. Output can be
  passed to \code{\link{fit2df}}. This is only currently set-up to take a single random effect
  as a random intercept. Can be updated in future to allow multiple random intercepts,
  random gradients and interactions on random effects if there is a need.
}
\examples{
library(finalfit)
library(dplyr)

explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
random_effect = "hospital"
dependent = "nodes"

colon_s \%>\%
  lmmixed(dependent, explanatory, random_effect) \%>\%
	 fit2df(estimate_suffix=" (multilevel")
}
\seealso{
\code{\link{fit2df}}

Other \code{finalfit} model wrappers: \code{\link{coxphmulti}},
  \code{\link{coxphuni}}, \code{\link{glmmixed}},
  \code{\link{glmmulti_boot}}, \code{\link{glmmulti}},
  \code{\link{glmuni}}, \code{\link{lmmulti}},
  \code{\link{lmuni}}
}
