% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit2df.R, R/fit2df_coxph.R,
%   R/fit2df_coxphlist.R, R/fit2df_glm.R, R/fit2df_glmboot.R,
%   R/fit2df_glmerMod.R, R/fit2df_glmlist.R, R/fit2df_lm.R, R/fit2df_lmerMod.R,
%   R/fit2df_lmlist.R, R/fit2df_stanfit.R
\name{fit2df}
\alias{fit2df}
\alias{fit2df.coxph}
\alias{fit2df.coxphlist}
\alias{fit2df.glm}
\alias{fit2df.glmboot}
\alias{fit2df.glmerMod}
\alias{fit2df.glmlist}
\alias{fit2df.lm}
\alias{fit2df.lmerMod}
\alias{fit2df.lmlist}
\alias{fit2df.stanfit}
\title{Extract model fit results to dataframe (generic): \code{finalfit} model extractors}
\usage{
fit2df(.data, condense, metrics, remove_intercept, explanatory_name,
  estimate_name, estimate_suffix, p_name, digits, confint_sep, ...)

\method{fit2df}{coxph}(.data, condense = TRUE, metrics = FALSE,
  remove_intercept = TRUE, explanatory_name = "explanatory",
  estimate_name = "HR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), confint_sep = "-", ...)

\method{fit2df}{coxphlist}(.data, condense = TRUE, metrics = FALSE,
  remove_intercept = TRUE, explanatory_name = "explanatory",
  estimate_name = "HR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), confint_sep = "-", ...)

\method{fit2df}{glm}(.data, condense = TRUE, metrics = FALSE,
  remove_intercept = TRUE, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), confint_sep = "-", ...)

\method{fit2df}{glmboot}(.data, condense = TRUE, metrics = FALSE,
  remove_intercept = TRUE, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), confint_sep = "-", ...)

\method{fit2df}{glmerMod}(.data, condense = TRUE, metrics = FALSE,
  remove_intercept = TRUE, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), confint_sep = "-", ...)

\method{fit2df}{glmlist}(.data, condense = TRUE, metrics = FALSE,
  remove_intercept = TRUE, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), confint_sep = "-", ...)

\method{fit2df}{lm}(.data, condense = TRUE, metrics = FALSE,
  remove_intercept = TRUE, explanatory_name = "explanatory",
  estimate_name = "Coefficient", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), confint_sep = " to ", ...)

\method{fit2df}{lmerMod}(.data, condense = TRUE, metrics = FALSE,
  remove_intercept = TRUE, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), confint_sep = "-", ...)

\method{fit2df}{lmlist}(.data, condense = TRUE, metrics = FALSE,
  remove_intercept = TRUE, explanatory_name = "explanatory",
  estimate_name = "Coefficient", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), confint_sep = " to ", ...)

\method{fit2df}{stanfit}(.data, condense = TRUE, metrics = FALSE,
  remove_intercept = TRUE, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), confint_sep = "-", ...)
}
\arguments{
\item{.data}{Output from \code{finalfit} model wrappers.}

\item{condense}{Logical: when true, effect estimates, confidence intervals and p-values
are pasted conveniently together in single cell.}

\item{metrics}{Logical: when true, useful model metrics are extracted.}

\item{remove_intercept}{Logical: remove the results for the intercept term.}

\item{explanatory_name}{Name for this column in output}

\item{estimate_name}{Name for this column in output}

\item{estimate_suffix}{Appeneded to estimate name}

\item{p_name}{Name given to p-value estimate}

\item{digits}{Number of digits to round to (1) estimate, (2) confidence
interval limits, (3) p-value.}

\item{confint_sep}{String to separate confidence intervals, typically "-" or
" to ".}

\item{...}{Other arguments: `X` Design matrix from stanfit modelling. Details
documented else where.}
}
\value{
A dataframe of model parameters. When \code{metrics=TRUE} output is a list of two dataframes,
  one is model parameters, one is model metrics. length two
}
\description{
Takes output from \code{finalfit} model wrappers and extracts to a dataframe,
convenient for further processing in preparation for final results table.

\code{fit2df.coxph} is the model extract method for \code{survival::\link[survival]{coxph}}.

\code{fit2df.coxphlist} is the model extract method for \code{coxphuni} and \code{coxphmulti}.

\code{fit2df.glm} is the model extract method for standard
\code{\link[stats]{glm}} models, which have not used \code{finalfit} model
wrappers.

\code{fit2df.glmboot} is the model extract method for \code{\link{glmmulti_boot}} models.

\code{fit2df.glmerMod} is the model extract method for standard
\code{lme4::\link[lme4]{glmer}} models and for the
\code{finalfit::\link{glmmixed}} model wrapper.

\code{fit2df.glmlist} is the model extract method for \code{glmuni} and \code{glmmulti}.

\code{fit2df.lm} is the model extract method for \code{\link[stats]{lm}}.

\code{fit2df.lmerMod} is the model extract method for standard
\code{lme4::\link[lme4]{lmer}} models and for the
\code{finalfit::\link{lmmixed}} model wrapper.

\code{fit2df.lmlist} is the model extract method for \code{lmuni} and
\code{lmmulti}.

\code{fit2df.stanfit} is the model extract method for our standard Bayesian
hierarchical binomial logistic regression models. These models will be fully
documented separately. However this should work for a single or multilevel
Bayesian logistic regression done in Stan, as long as the fixed effects are
specified in the parameters block as a vector named \code{beta}, of length
\code{P}, where \code{P} is the number of fixed effect parameters. e.g.
parameters{ vector[P] beta; }
}
\details{
\code{fit2df} is a generic (S3) function for model extract.
}
\examples{
library(finalfit)
library(dplyr)
library(survival)
# glm
fit = glm(mort_5yr ~  age.factor + sex.factor + obstruct.factor + perfor.factor,
  data=colon_s, family="binomial")
fit \%>\%
  fit2df(estimate_suffix=" (multivariable)")

# glmlist
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "mort_5yr"
colon_s \%>\%
	glmmulti(dependent, explanatory) \%>\%
	fit2df(estimate_suffix=" (univariable)")

# glmerMod
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
random_effect = "hospital"
dependent = "mort_5yr"
colon_s \%>\%
  glmmixed(dependent, explanatory, random_effect) \%>\%
	 fit2df(estimate_suffix=" (multilevel")

# glmboot
## Note number of draws set to 100 just for speed in this example
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "mort_5yr"
colon_s \%>\%
	glmmulti_boot(dependent, explanatory,  R = 100) \%>\%
	fit2df(estimate_suffix=" (multivariable (BS CIs))")

# lm
fit = lm(nodes ~  age.factor + sex.factor + obstruct.factor + perfor.factor,
  data=colon_s)
fit \%>\%
  fit2df(estimate_suffix=" (multivariable)")

# lmerMod
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
random_effect = "hospital"
dependent = "nodes"

colon_s \%>\%
  lmmixed(dependent, explanatory, random_effect) \%>\%
	 fit2df(estimate_suffix=" (multilevel")

# coxphlist
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "Surv(time, status)"

colon_s \%>\%
	coxphuni(dependent, explanatory) \%>\%
	fit2df(estimate_suffix=" (univariable)")

colon_s \%>\%
	coxphmulti(dependent, explanatory) \%>\%
	fit2df(estimate_suffix=" (multivariable)")

# coxph
fit = coxph(Surv(time, status) ~ age.factor + sex.factor + obstruct.factor + perfor.factor,
  data = colon_s)

fit \%>\%
	fit2df(estimate_suffix=" (multivariable)")
}
