% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_missing.R
\name{ff_missing}
\alias{ff_missing}
\alias{finalfit_missing}
\title{Characterise missing data for \code{finalfit} models}
\usage{
ff_missing(.data, dependent = NULL, explanatory = NULL)

finalfit_missing(.data, dependent = NULL, explanatory = NULL)
}
\arguments{
\item{.data}{Dataframe. Missing values must be coded \code{NA}.}

\item{dependent}{Character vector usually of length 1, name of depdendent
variable.}

\item{explanatory}{Character vector of any length: name(s) of explanatory
variables.
to a missing data pattern (1=observed, 0=missing). Rows and columns are
sorted in increasing amounts of missing information. The last column and
row contain row and column counts, respectively.}
}
\description{
Using \code{finalfit} conventions, produces a missing data matrix using
\code{\link[mice]{md.pattern}}.
}
\examples{
library(finalfit)
library(dplyr)
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "mort_5yr"

colon_s \%>\%
	finalfit_missing(dependent, explanatory)

}
