% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalfit_internal_functions.R
\name{extract_fit}
\alias{extract_fit}
\alias{extract_fit.glm}
\alias{extract_fit.glmerMod}
\alias{extract_fit.lm}
\alias{extract_fit.lmerMod}
\alias{extract_fit.coxph}
\alias{extract_fit.stanfit}
\title{Extract model output to dataframe}
\usage{
extract_fit(.data, explanatory_name, estimate_name, estimate_suffix,
  p_name, digits, ...)

\method{extract_fit}{glm}(.data, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), ...)

\method{extract_fit}{glmerMod}(.data, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), ...)

\method{extract_fit}{lm}(.data, explanatory_name = "explanatory",
  estimate_name = "Coefficient", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), ...)

\method{extract_fit}{lmerMod}(.data, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), ...)

\method{extract_fit}{coxph}(.data, explanatory_name = "explanatory",
  estimate_name = "HR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), ...)

\method{extract_fit}{stanfit}(.data, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), X, ...)
}
\arguments{
\item{.data}{Model output.}

\item{explanatory_name}{Name for this column in output.}

\item{estimate_name}{Name for this column in output.}

\item{estimate_suffix}{Appeneded to estimate name.}

\item{p_name}{Name given to p-value estimate}

\item{digits}{Number of digits to round to (1) estimate, (2) confidence
interval limits, (3) p-value.}

\item{...}{Other arguments.}

\item{X}{Design matrix from Stan modelling procedure.}
}
\description{
Internal function, not called directly.

Internal function, not called directly.

Internal function, not called directly.

Internal function, not called directly.

Internal function, not called directly.

Internal function, not called directly.

Internal function, not called directly.
}
\keyword{internal}
