% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalfit_internal_functions.R
\name{condense_fit}
\alias{condense_fit}
\title{Condense model output dataframe for final tables}
\usage{
condense_fit(
  .data,
  explanatory_name = "explanatory",
  estimate_name = NA,
  estimate_suffix = "",
  p_name = "p",
  digits = c(2, 2, 3),
  confint_sep = "-"
)
}
\arguments{
\item{.data}{Dataframe of four or five columns, must be this order, (1) explanatory
variable names, (2) estimate, (3) confidence interval lower limit, (4)
confidence interval upper limit, (5) p-value (optional).}

\item{explanatory_name}{Name for this column in output}

\item{estimate_name}{Name for this column in output}

\item{estimate_suffix}{Appeneded to estimate name}

\item{p_name}{Name given to p-value estimate}

\item{digits}{Number of digits to round to (1) estimate, (2) confidence
interval limits, (3) p-value.}

\item{confint_sep}{String to separate confidence intervals, typically "-" or
" to ".}
}
\description{
Internal function, not called directly. Can only be used in conjunction with
  extract_fit
}
\keyword{internal}
