% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwca.R
\name{dwca_read}
\alias{dwca_read}
\title{Parse Darwin Core Archive}
\usage{
dwca_read(input, read = FALSE, ...)
}
\arguments{
\item{input}{(character) Path to local zip file, directory, or a url.
If a URL it must be for a zip file.}

\item{read}{(logical) Whether or not to read in data files. If \code{FALSE},
we give back paths to files only. Default: \code{FALSE}}

\item{...}{Further args passed on to \code{\link[data.table:fread]{data.table::fread()}}}
}
\description{
Parse Darwin Core Archive
}
\details{
Note that sometimes file reads fail. We use \code{\link[data.table:fread]{data.table::fread()}}
internally, which is very fast, but can fail sometimes. If so, try reading
in the data manually.

When you pass in a URL, we use \pkg{rappdirs} to determine cache path, and
if you pass the same URL again, and your cache is not cleared, we'll
pull from the cache. Passing a file or directory on your local system
won't invoke the caching route, but will go directly to the file/directory.
}
\examples{
\dontrun{
# set up a temporary directory for the example
dwca_cache$cache_path_set(path = "finch", type = "tempdir")

dir <- system.file("examples", "0000154-150116162929234", package = "finch")

# Don't read data in
(x <- dwca_read(dir, read=FALSE))
x$files
x$highmeta
x$dataset_meta[[1]]
x$data

# Read data
(x <- dwca_read(dir, read=TRUE))
head(x$data[[1]])

# Can pass in a zip file
zip <- system.file("examples", "0000154-150116162929234.zip",
  package = "finch")
(out <- dwca_read(zip))
out$files
out$highmeta
out$emlmeta
out$dataset_meta

# Can pass in zip file as a url
url <-
"https://github.com/ropensci/finch/blob/master/inst/examples/0000154-150116162929234.zip?raw=true"
(out <- dwca_read(url))

# another url
url <- "http://ipt.jbrj.gov.br/jbrj/archive.do?r=redlist_2013_taxons&v=3.12"
(out <- dwca_read(url))
}
}
