% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{indicators_unique}
\alias{indicators_unique}
\title{Live indicators}
\usage{
indicators_unique(ProfileID = NULL, DomainID = NULL, path)
}
\arguments{
\item{ProfileID}{Numeric vector, id of profiles of interest}

\item{DomainID}{Numeric vector, id of domains of interest}

\item{path}{String; Fingertips API address. Function will default to the
correct address}
}
\value{
A data frame of indicator ids and names
}
\description{
Outputs a data frame of indicators (their id and name only). Note, this
function can take up to a few minutes to run (depending on internet
connection speeds)
}
\examples{
indicators_unique(ProfileID = 21)
}
\seealso{
\code{\link{indicators}} for indicators and their parent domains and
  profiles, \code{\link{area_types}} for area type  and their parent
  mappings, \code{\link{indicator_metadata}} for indicator metadata and
  \code{\link{profiles}} for profile lookups and
  \code{\link{deprivation_decile}} for deprivation decile lookups and
  \code{\link{category_types}} for category lookups,
  \code{\link{indicator_areatypes}} for indicators by area types lookups and
  \code{\link{indicator_order}} for the order indicators are presented on the
  Fingertips website within a Domain

Other lookup functions: \code{\link{area_types}},
  \code{\link{category_types}},
  \code{\link{deprivation_decile}},
  \code{\link{indicator_areatypes}},
  \code{\link{indicator_metadata}},
  \code{\link{indicator_order}}, \code{\link{indicators}},
  \code{\link{nearest_neighbours}}, \code{\link{profiles}}
}
\concept{lookup functions}
