% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_charts.R
\name{overview}
\alias{overview}
\title{Plot an overview (tartan rug) of multiple indicators}
\usage{
overview(
  data,
  area,
  indicator,
  value,
  fill,
  timeperiod,
  top_areas,
  wrap_length = 50,
  value_label_size = 1,
  legend_position = "none"
)
}
\arguments{
\item{data}{data.frame object to plot using ggplot2 functions}

\item{area}{field containing area names (unquoted)}

\item{indicator}{field containing indicator names (unquoted)}

\item{value}{field containing variable to be plotted (unquoted)}

\item{fill}{field to be used to determine the colouring of the bars (unquoted)}

\item{timeperiod}{field containing the time period (unquoted)}

\item{top_areas}{character vector; the areas to fix at the left}

\item{wrap_length}{number; maximum number of characters in indicator before
wrapping it}

\item{value_label_size}{number; amount to scale the size of the value label}

\item{legend_position}{the position of legends ("none", "left", "right",
"bottom", "top", or two-element numeric vector)}
}
\value{
a ggplot of the overview/tartan rug plot
}
\description{
Plot an overview (tartan rug) of multiple indicators
}
\examples{
library(dplyr)
df <- create_test_data()

parent <- "PAC14"
top_names <- c("C001", parent)
df_over <- df \%>\%
        filter((AreaCode \%in\% top_names |
                        ParentAreaCode == parent)) \%>\%
        mutate(Value = round(Value, 1))
p <- overview(df_over,
              area = AreaCode,
              indicator = IndicatorName,
              value = Value,
              timeperiod = Timeperiod,
              fill = Significance,
              top_areas = top_names,
              wrap_length = 40,
              value_label_size = 0.8)
p
}
\seealso{
Other quick charts: 
\code{\link{box_plots}()},
\code{\link{compare_areas}()},
\code{\link{compare_indicators}()},
\code{\link{map}()},
\code{\link{population}()},
\code{\link{trends}()}
}
\concept{quick charts}
