# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Chi^2(1) Percentile
#'
#' @description Returns the Chi^2(1) percentile for the test statistic.
#' @param value Chi^2(1) value (type: double).
#' @return Chi^2(1) percentile (type: double).
#' @examples
#' get_chisq1_percentile(20.0)
#' @export
get_chisq1_percentile <- function(value) {
    .Call(`_finity_get_chisq1_percentile`, value)
}

#' Absolute Moment of Order k
#' 
#' @description Computes the absolute moment of order k of a sample of observations.
#' @param obs Observations (type: armadillo numeric vector).
#' @param k Moment order (type: double)
#' @return Moment value (type: double)
#' @examples
#' library(stabledist)
#' rvs <- rstable(100000, 1.9, 0.5, 1, 0, pm = 0)
#' absolute_moment <- compute_absolute_moment(rvs, 2)
#' @export
compute_absolute_moment <- function(obs, k) {
    .Call(`_finity_compute_absolute_moment`, obs, k)
}

#' Finite Moment Test 
#' 
#' @description Computes Trapani's (2016) finite moment test for moment of order k of the distribution of a given the sample of observations obs. Knowledge of the identity of the distribution is not required. The null hypothesis is that the moment is infinite; the alternative is that it is finite. The function takes parameters of the test as optional arguments; some insights into the impact the choice of parameter values has are given in Trapani (2016).
#' @param obs Observations (type: armadillo numeric vector).
#' @param k Moment order (type: double)
#' @param r Artificial sample size (type: int). Default is N^0.8.
#' @param psi Pescaling moment (type: double). Must be <k. Default is 2.0.
#' @param u Sampling range width for sampling range [-u, u] (type: double) Default is 1.0.
#' @param force_random_variate_sample If True, draw random variates for xi and u_series. If False, use quantile function values from a regular percentile space grid. This represents the density function better. Defaiult is False.
#' @param ignore_errors Ignore errors caused by Inf and NaN results for too large absolute moments. If True, it will return test statistic=NA, pvalue=1. If False, it will stop with an error. Default is False. But normally this will indicate an infinite moment.
#' @param verbose If True, print detailed output for debugging. Default is False.
#' @param random_salting Salt number to be added to the random seed (type: int). This prevents identical random variate series if multiple instances are started and run in parallel. Default is 0.
#' @return Trapani's Theta test statistic (type: double).
#' @return Corresponding p-value (Chi^2(1) percentile) (type: double).
#' @examples
#' library(stabledist)
#' rvs <- rstable(100000, 1.9, 0.5, 1, 0, pm = 0)
#' result <- finite_moment_test(rvs, 2)
#' @export
finite_moment_test <- function(obs, k, r = 0L, psi = 2, u = 1.0, force_random_variate_sample = 0L, ignore_errors = 0L, verbose = 0L, random_salting = 0L) {
    .Call(`_finity_finite_moment_test`, obs, k, r, psi, u, force_random_variate_sample, ignore_errors, verbose, random_salting)
}

