% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_concept_network.R
\name{fst_cn_nodes}
\alias{fst_cn_nodes}
\title{Concept Network - Get textrank nodes}
\usage{
fst_cn_nodes(data, edges, pos_filter = NULL)
}
\arguments{
\item{data}{A dataframe of text in CoNLL-U format.}

\item{edges}{Output of `fst_cn_edges()`, dataframe of co-occurrences between
two words.}

\item{pos_filter}{List of UPOS tags for inclusion, default is `NULL` to
include all UPOS tags.}
}
\value{
A dataframe containing relevant lemmas and their associated pagerank.
}
\description{
This function takes a string of terms (separated by commas) or a single term
and, using `textrank_keywords()` from `textrank` package, filters data based
on `pos_filter` ranks words which are the filtered for those connected to
search terms.
}
\examples{
con <- "kiusata, lyöminen"
cb <- conllu_cb_bullying_iso
edges <- fst_cn_edges(cb, con, pos_filter = c("NOUN", "VERB", "ADJ", "ADV"))
fst_cn_nodes(cb, edges, c("NOUN", "VERB", "ADJ", "ADV"))
}
