% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_concept_network.R
\name{fst_concept_network}
\alias{fst_concept_network}
\title{Concept Network - Make Concept Network plot}
\usage{
fst_concept_network(
  data,
  concepts,
  threshold = NULL,
  norm = "number_words",
  pos_filter = NULL,
  title = NULL
)
}
\arguments{
\item{data}{A dataframe of text in CoNLL-U format.}

\item{concepts}{List of terms to search for, separated by commas.}

\item{threshold}{A minimum number of occurrences threshold for 'edge' between
searched term and other word, default is `NULL`. Note, the threshold is
applied before normalisation.}

\item{norm}{The method for normalising the data. Valid settings are
`"number_words"` (the number of words in the responses, default),
`"number_resp"` (the number of responses), or `NULL` (raw count returned).}

\item{pos_filter}{List of UPOS tags for inclusion, default is `NULL` to
include all UPOS tags.}

\item{title}{Optional title for plot, default is `NULL` and a generic title
("Textrank extracted keyword occurrences") will be used.}
}
\value{
Plot of Concept Network.
}
\description{
This function takes a string of terms (separated by commas) or a single term
and, using `textrank_keywords()` from `textrank` package, filters data based
on `pos_filter` and finds words connected to search terms. Then it plots a
Concept Network based on the calculated weights of these terms and the
frequency of co-occurrences.
}
\examples{
data <- conllu_cb_bullying_iso
con <- "kiusata, lyöminen"
pf <- c("NOUN", "VERB", "ADJ", "ADV")
title <- "Bullying Concept Network"
fst_concept_network(data, concepts = con, pos_filter = pf, title = title)
}
