% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_data_exploration.R
\name{fst_freq_plot}
\alias{fst_freq_plot}
\title{Make Top Words plot}
\usage{
fst_freq_plot(table, number = NULL, name = NULL)
}
\arguments{
\item{table}{Output of `fst_get_top_words()` or `fst_get_top_ngrams()`.}

\item{number}{Optional number of n-grams for the title, default is `NULL`.}

\item{name}{An optional "name" for the plot to add to title, default is
`NULL`.}
}
\value{
Plot of top words.
}
\description{
Plots most common words.
}
\examples{
cb <- conllu_cb_bullying
pf <- c("NOUN", "VERB", "ADJ", "ADV")
top_bullying_words <- fst_get_top_words(cb, number = 15, pos_filter = pf)
fst_freq_plot(top_bullying_words, number = 5, name = "Bullying")

q11_1 <- conllu_dev_q11_1_nltk
q11_1_ngrams <- fst_get_top_ngrams(q11_1, number = 10, ngrams = 1)
fst_freq_plot(q11_1_ngrams)
}
