% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_functions.R
\name{fst_length_compare}
\alias{fst_length_compare}
\title{Compare response lengths}
\usage{
fst_length_compare(
  data1,
  data2,
  data3 = NULL,
  data4 = NULL,
  name1 = "Group 1",
  name2 = "Group 2",
  name3 = "Group 3",
  name4 = "Group 4",
  incl_sentences = TRUE
)
}
\arguments{
\item{data1}{A dataframe of text in CoNLL-U format for the first group.}

\item{data2}{A dataframe of text in CoNLL-U format for the second group.}

\item{data3}{An optional dataframe of text in CoNLL-U format for the third
group, default is `NULL`.}

\item{data4}{An optional dataframe of text in CoNLL-U format for the fourth
group, default is `NULL`.}

\item{name1}{A string describing data1, default is `"Group 1"`.}

\item{name2}{A string describing data2, default is `"Group 2"`.}

\item{name3}{A string describing data3, default is `"Group 3"`.}

\item{name4}{A string describing data4, default is `"Group 4"`.}

\item{incl_sentences}{Whether to include sentence data in table, default is
`TRUE`.}
}
\value{
Dataframe summarising response lengths.
}
\description{
Compare length of text responses for between 2 and 4 sets of prepared data.
}
\examples{
f <- conllu_dev_q11_1_f_nltk
m <- conllu_dev_q11_1_m_nltk
na <- conllu_dev_q11_1_na_nltk
all <- conllu_dev_q11_1_nltk
fst_length_compare(f, m, na, all, "Female", "Male", "Not Spec", "All")
fst_length_compare(f, m, name1 = "F", name2 = "M", incl_sentences = FALSE)
}
