% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kumaraswamy.R
\name{EstMLEKumBin}
\alias{EstMLEKumBin}
\title{Estimating the shape parameters a and b and iterations for  Kumaraswamy Binomial Distribution}
\usage{
EstMLEKumBin(x,freq,a,b,it,...)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{a}{single value for shape parameter alpha representing as a.}

\item{b}{single value for shape parameter beta representing as b.}

\item{it}{number of iterations to converge as a proper probability function
replacing infinity.}

\item{...}{mle2 function inputs except data and estimating parameter.}
}
\value{
\code{EstMLEKumBin} here is used as a wrapper for the \code{mle2} function of
\pkg{bbmle} package therefore output is of class of mle2.
}
\description{
The function will estimate the shape parameters using the maximum log likelihood method  for
the Kumaraswamy Binomial distribution when the binomial random variables and
corresponding frequencies are given
}
\details{
\deqn{0 < a,b}
\deqn{x = 0,1,2,...}
\deqn{freq \ge 0}
\deqn{it > 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary
error messages will be provided to go further.
}
\examples{
No.D.D <- 0:7     #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)  #assigning the corresponding frequencies

\dontrun{
#estimating the parameters using maximum log likelihood value and assigning it
parameters1 <- EstMLEKumBin(x=No.D.D,freq=Obs.fre.1,a=10.1,b=1.1,it=10000)

bbmle::coef(parameters1)   #extracting the parameters
}
}
\references{
\insertRef{xiaohu2011kumaraswamy}{fitODBOD}
}
\seealso{
\code{\link[bbmle]{mle2}}
}
