## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
suppressWarnings(suppressPackageStartupMessages({library(fitPS)}))

## ----results='asis', echo=FALSE-----------------------------------------------
knitr::kable(Psurveys$roux$data, 
             col.names = c("$n$", "$r_n$"),
             align = "rr")

## -----------------------------------------------------------------------------
roux = Psurveys$roux

## -----------------------------------------------------------------------------
roux

## -----------------------------------------------------------------------------
fit = fitDist(roux)

## -----------------------------------------------------------------------------
print(fit, nterms = 6)

## -----------------------------------------------------------------------------
ci = confint(fit)
ci$wald
ci$prof

## -----------------------------------------------------------------------------
ci$wald + 1
ci$prof + 1

