% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareSurveysLRT.R
\name{compareSurveysLRT}
\alias{compareSurveysLRT}
\title{Compare two or more surveys on the basis of their shape parameters using a Likelihood Ratio Test}
\usage{
compareSurveysLRT(...)
}
\arguments{
\item{\ldots}{two or more objects of class \code{"psData"}---see \code{\link{readData}}.}
}
\value{
The function returns a \code{list} of class \code{"htest"} with the following elements:
\describe{
 \item{\code{statistic}}{ -- the test statistic.}
 \item{\code{parameter}}{ -- the degrees of freedom for the test}
 \item{\code{p.value}}{ -- the P-value associated with the estimate.}
 \item{\code{method}}{ -- a character string describing the method hypothesis.}
 \item{\code{data.name}}{ -- the names of the data sets used in the test}
}
}
\description{
Compare two or more surveys on the basis of their shape parameters using a Likelihood Ratio Test
}
\details{
This function **only** works for the zeta distribution. The function carries out a likelihood ratio test (LRT) to test the null hypothesis
\deqn{H_0: \alpha_1 = \alpha_2 = \ldots = \alpha_K}{H_0: alpha_1 = alpha_2 = \ldots = alpha_K} versus the alternative
\deqn{H_1: \alpha_i \neq \alpha_j \mbox{ for some } i \neq j \in \left\{1, \ldots, K\right\},}{H_1: alpha_i != alpha_j for some  i != j in {1, \ldots, K},}
where \eqn{\alpha_i}{alpha_i} is the shape parameter for the zeta distribution of the \eqn{i^\mathrm{th}}{ith} survey.
}
\examples{
data(Psurveys)
lau = Psurveys$lau
jackson = Psurveys$jackson
compareSurveysLRT(lau, jackson)

## Example with three surveys
roux = Psurveys$roux
compareSurveysLRT(lau, jackson, roux)

}
