% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitbit_utils.R
\name{crop_DEM}
\alias{crop_DEM}
\title{Function to crop the AOI from the downloaded DEM .tif file}
\usage{
crop_DEM(
  tif_or_vrt_dem_file,
  sf_buffer_obj,
  CRS = 4326,
  digits = 6,
  verbose = FALSE
)
}
\arguments{
\item{tif_or_vrt_dem_file}{a valid path to the elevation .tif or .vrt file}

\item{sf_buffer_obj}{a simple features ('sf') object that will be used to crop the input elevation raster file ('tif_or_vrt_dem_file' parameter)}

\item{CRS}{an integer specifying the Coordinates Reference System. The recommended value for this data is 4326 (which is also the default value)}

\item{digits}{the number of digits to use. It defaults to 6}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}
}
\value{
an object of class raster
}
\description{
Function to crop the AOI from the downloaded DEM .tif file
}
\examples{

\dontrun{

require(fitbitViz)

#............................
# first extract the log-id(s)
#............................

USER_ID = '99xxxx'
token = 'my_long_web_api_token'

log_id = extract_LOG_ID(user_id = USER_ID,
                        token = token,
                        after_Date = '2021-03-13',
                        limit = 10,
                        sort = 'asc',
                        verbose = TRUE)
str(log_id)

#...................................
# then return the gps-ctx data.table
#...................................

res_tcx = GPS_TCX_data(log_id = log_id,
                       user_id = USER_ID,
                       token = token,
                       time_zone = 'Europe/Athens',
                       verbose = TRUE)
str(res_tcx)

#....................................................
# then compute the sf-object buffer and raster-extend
#....................................................

sf_rst_ext = extend_AOI_buffer(dat_gps_tcx = res_tcx,
                               buffer_in_meters = 1000,
                               CRS = 4326,
                               verbose = TRUE)
sf_rst_ext

#...............................................................
# Download the Copernicus DEM 30m elevation data because it has
# a better resolution, it takes a bit longer to download because
# the .tif file size is bigger
#...............................................................

dem_dir = tempdir()
# dem_dir

dem30 = CopernicusDEM::aoi_geom_save_tif_matches(sf_or_file = sf_rst_ext$sfc_obj,
                                                 dir_save_tifs = dem_dir,
                                                 resolution = 30,
                                                 crs_value = 4326,
                                                 threads = parallel::detectCores(),
                                                 verbose = TRUE)

TIF = list.files(dem_dir, pattern = '.tif', full.names = T)
# TIF

if (length(TIF) > 1) {

  #....................................................
  # create a .VRT file if I have more than 1 .tif files
  #....................................................

  file_out = file.path(dem_dir, 'VRT_mosaic_FILE.vrt')

  vrt_dem30 = create_VRT_from_dir(dir_tifs = dem_dir,
                                  output_path_VRT = file_out,
                                  verbose = TRUE)
}

if (length(TIF) == 1) {

  #..................................................
  # if I have a single .tif file keep the first index
  #..................................................

  file_out = TIF[1]
}

raysh_rst = crop_DEM(tif_or_vrt_dem_file = file_out,
                     sf_buffer_obj = sf_rst_ext$sfc_obj,
                     CRS = 4326,
                     digits = 6,
                     verbose = TRUE)

sp::plot(raysh_rst)

}
}
