% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitbit_utils.R
\name{gps_lat_lon_to_LINESTRING}
\alias{gps_lat_lon_to_LINESTRING}
\title{Convert the GPS, TCX data to a LINESTRING}
\usage{
gps_lat_lon_to_LINESTRING(
  dat_gps_tcx,
  CRS = 4326,
  verbose = FALSE,
  time_split_asc_desc = NULL
)
}
\arguments{
\item{dat_gps_tcx}{this parameter corresponds to the output data.table of the 'GPS_TCX_data()' function}

\item{CRS}{an integer specifying the Coordinates Reference System. The recommended value for this data is 4326 (which is also the default value)}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}

\item{time_split_asc_desc}{if NULL then the maximum altitude coordinates point will be used as a split point of the route, otherwise the user can give a lubridate 'hours-minutes-seconds' object such as: lubridate::hms('17:05:00')}
}
\value{
an object of class list
}
\description{
Convert the GPS, TCX data to a LINESTRING
}
\details{
Separate the Ascending and Descending coordinate points into 2 groups and give a different color to the Ascending and Descending routes
}
\examples{

\dontrun{

require(fitbitViz)

#............................
# first extract the log-id(s)
#............................

USER_ID = '99xxxx'
token = 'my_long_web_api_token'

log_id = extract_LOG_ID(user_id = USER_ID,
                        token = token,
                        after_Date = '2021-03-13',
                        limit = 10,
                        sort = 'asc',
                        verbose = TRUE)
str(log_id)

#...................................
# then return the gps-ctx data.table
#...................................

res_tcx = GPS_TCX_data(log_id = log_id,
                       user_id = USER_ID,
                       token = token,
                       time_zone = 'Europe/Athens',
                       verbose = TRUE)
str(res_tcx)


#..................................................................
# By using using the maximum altitude as a split point of the route
#..................................................................

linestring_dat_init = gps_lat_lon_to_LINESTRING(dat_gps_tcx = res_tcx,
                                                CRS = 4326,
                                                time_split_asc_desc = NULL,
                                                verbose = TRUE)

#.................................................................
# By using a customized split of the route (ascending, descending)
#.................................................................

linestring_dat_lubr = gps_lat_lon_to_LINESTRING(dat_gps_tcx = res_tcx,
                                                CRS = 4326,
                                                time_split_asc_desc = lubridate::hms('17:05:00'),
                                                verbose = TRUE)
}
}
