% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitbit_utils.R
\name{leafGL_point_coords}
\alias{leafGL_point_coords}
\title{Create a Leafet map (including information pop-ups)}
\usage{
leafGL_point_coords(
  dat_gps_tcx,
  color_points_column = "AltitudeMeters",
  provider = leaflet::providers$Esri.WorldImagery,
  option_viewer = rstudioapi::viewer,
  CRS = 4326
)
}
\arguments{
\item{dat_gps_tcx}{this parameter corresponds to the output data.table of the 'GPS_TCX_data()' function}

\item{color_points_column}{a character string specifying the column of the output data.table ('GPS_TCX_data()' function) that is used in the map-markers. The default value is 'AltitudeMeters' but it can be any column of type numeric}

\item{provider}{either a character string specifying a leaflet provider (such as 'Esri.WorldImagery') or a direct call to the leaflet provider list (such as leaflet::providers$Esri.WorldImagery). The default value is leaflet::providers$Esri.WorldImagery}

\item{option_viewer}{either NULL or rstudioapi::viewer. If NULL then the output map will be shown in the web browser}

\item{CRS}{an integer specifying the Coordinates Reference System. The recommended value for this data is 4326 (which is also the default value)}
}
\value{
a leaflet map of class 'leaflet'
}
\description{
Create a Leafet map (including information pop-ups)
}
\examples{

\dontrun{

require(fitbitViz)

#............................
# first extract the log-id(s)
#............................

USER_ID = '99xxxx'
token = 'my_long_web_api_token'

log_id = extract_LOG_ID(user_id = USER_ID,
                        token = token,
                        after_Date = '2021-03-13',
                        limit = 10,
                        sort = 'asc',
                        verbose = TRUE)
str(log_id)

#...................................
# then return the gps-ctx data.table
#...................................

res_tcx = GPS_TCX_data(log_id = log_id,
                       user_id = USER_ID,
                       token = token,
                       time_zone = 'Europe/Athens',
                       verbose = TRUE)
str(res_tcx)


#........................
# then visualize the data
#........................

res_lft = leafGL_point_coords(dat_gps_tcx = res_tcx,
                              color_points_column = 'AltitudeMeters',
                              provider = leaflet::providers$Esri.WorldImagery,
                              option_viewer = rstudioapi::viewer,
                              CRS = 4326)
res_lft

}
}
