% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02a_reltest.R
\name{reltest}
\alias{reltest}
\title{Evaluation of Reliability for Models in the \code{fitdistcp} Package}
\usage{
reltest(
  model = "exp",
  ntrials = 1000,
  nrepeats = 3,
  nx = 20,
  params = c(1),
  alpha = seq(0.005, 0.995, 0.005),
  plotflag = TRUE,
  verbose = TRUE,
  dmgs = TRUE,
  debug = FALSE,
  aderivs = TRUE,
  unbiasedv = FALSE,
  pwm = FALSE,
  minxi = -10,
  maxxi = 10
)
}
\arguments{
\item{model}{which distribution to test. Possibles values are
"\code{exp}",
"\code{pareto_k1}",
"\code{halfnorm}",
"\code{unif}",
"\code{norm}",
"\code{norm_dmgs}",
"\code{gnorm_k3}",
"\code{lnorm}",
"\code{lnorm_dmgs}",
"\code{logis}",
"\code{lst_k3}",
"\code{cauchy}",
"\code{gumbel}",
"\code{frechet_k1}",
"\code{weibull}",
"\code{gev_k3}",
"\code{exp_p1}",
"\code{pareto_p1k3}",
"\code{norm_p1}",
"\code{lnorm_p1}",
"\code{logis_p1}",
"\code{lst_p1k4}",
"\code{cauchy_p1}",
"\code{gumbel_p1}",
"\code{frechet_p2k1}",
"\code{weibull_p2}",
"\code{gev_p1k4}",
"\code{norm_p12}",
"\code{lst_p12k5}",
"\code{gamma}",
"\code{invgamma}",
"\code{invgauss}",
"\code{gev}",
"\code{gpd_k1}",
"\code{gev_p1}".
"\code{gev_p12}".
"\code{gev_p123}".}

\item{ntrials}{the number of trials to run. 5000 typically gives good results.}

\item{nrepeats}{the number of entire repeats of the test to run, to check for convergence. 3 is a good choice.}

\item{nx}{the length of the training data to use.}

\item{params}{values for the parameters for the specified distribution}

\item{alpha}{the exceedance probability values at which to test}

\item{plotflag}{logical to turn the plotting on and off}

\item{verbose}{logical to turn loop counting on and off}

\item{dmgs}{logical to turn DMGS calculations on and off (to optimize speed for maxlik only calculations)}

\item{debug}{logical for turning debug messages on and off}

\item{aderivs}{logical for whether to use analytic derivatives (instead of numerical)}

\item{unbiasedv}{logical for whether to use the unbiased variance instead of maxlik (for the normal)}

\item{pwm}{logical for whether to use PWM instead of maxlik (for the GEV)}

\item{minxi}{minimum value for EVT shape parameter}

\item{maxxi}{maximum value for EVT shape parameter}
}
\value{
A plot showing 9 different reliability checks, and a list containing
various outputs, including the
probabilities shown in the plot.
}
\description{
Uses simulations to evaluate the reliability of
the predictive quantiles produced by the \code{q****_cp} routines in the \code{fitdistcp} package.
}
\details{
The maximum likelihood quantiles (plotted in blue) do not give good reliability.
They typically underestimate the tails (see panel (f)).

For
"\code{exp}",
"\code{pareto_k1}",
"\code{unif}",
"\code{norm}",
"\code{lnorm}",
"\code{norm_p1}" and
"\code{lnorm_p1}",
the calibrating prior quantiles are calculated using the right Haar prior
and an exact solution for the Bayesian prediction integral.
They will converge towards exact reliability with a large enough number of trials,
for any sample size.

For
"\code{halfnorm}",
"\code{norm_dmgs}",
"\code{lnorm_dmgs}",
"\code{gnorm_k3}",
"\code{logis}",
"\code{lst_k3}",
"\code{cauchy}",
"\code{gumbel}",
"\code{frechet_k1}",
"\code{weibull}",
"\code{gev_k3}",
"\code{exp_p1}",
"\code{pareto_p1k3}",
"\code{gumbel_p1}",
"\code{logis_p1}" and
"\code{lst_p1k4}"
"\code{cauchy_p1}",
"\code{gumbel_p1}",
"\code{frechet_p2k1}",
"\code{weibull_p2}",
"\code{gev_p1k4}",
"\code{norm_p12}",
"\code{lst_p12k5}"
the calibrating prior quantiles are calculated using the right Haar prior,
with the DMGS asymptotic solution for the Bayesian prediction integral.
They will converge towards good reliability with a large enough number of trials,
with the only deviation from exact reliability being due to the neglect of
higher order terms in the asymptotic expansion.
They will converge towards exact reliability with a large enough number of trials
and a large enough sample size.

For
"\code{gamma}",
"\code{invgamma}",
"\code{invgauss}",
"\code{gev}",
"\code{gpd_k1}" and
"\code{gev_p1}",
"\code{gev_p12}",
"\code{gev_p123}",
the calibrating prior quantiles are calculated using the "\code{fitdistcp}"
recommended calibrating priors,
with the DMGS asymptotic solution for the Bayesian prediction integral.
The chosen priors give reasonably good reliability with a
large enough number of trials,
and for large sample sizes, but may give poor reliability for small
sample sizes (e.g., n<20).
}
\examples{
set.seed(1)
# example 1
# -runs the default settings, which test reliability for the exponential distribution
reltest()

}
\references{
If you use this package, we would be grateful if you would cite the following reference,
which gives the various calibrating priors, and tests them for reliability:

\itemize{
\item Jewson S., Sweeting T. and Jewson L. (2024): Reducing Reliability Bias in
Assessments of Extreme Weather Risk using Calibrating Priors;
ASCMO Advances in Statistical Climatology, Meteorology and Oceanography),
\url{https://ascmo.copernicus.org/articles/11/1/2025/}.
}
}
\seealso{
An introduction to \code{fitdistcp}, with more examples,
is given \href{http://www.fitdistcp.info/index.html}{on this webpage}.

The \code{fitdistcp} package currently includes the following models (in alphabetical order):
\itemize{
\item Cauchy (\code{cauchy}),
\item Cauchy with linear predictor on the mean (\code{cauchy_p1}),
\item Exponential (\code{exp}),
\item Exponential with log-linear predictor on the scale (\code{exp_p1}),
\item Frechet with known location parameter (\code{frechet_k1}),
\item Frechet with log-linear predictor on the scale and known location parameter
(\code{frechet_p2k1}),
\item Gamma (\code{gamma}),
\item Generalized normal (\code{gnorm}),
\item GEV (\code{gev}),
\item GEV with linear predictor on the location (\code{gev_p1}),
\item GEV with linear predictor on the location and log-linear prediction on the scale
(\code{gev_p12}),
\item GEV with linear predictor on the location, log-linear prediction on the scale,
and linear predictor on the shape (\code{gev_p123}),
\item GEV with linear predictor on the location and known shape (\code{gev_p1k3}),
\item GEV with known shape (\code{gev_k3}),
\item GPD with known location (\code{gpd_k1}),
\item Gumbel (\code{gumbel}),
\item Gumbel with linear predictor on the mean(\code{gumbel_p1}),
\item Half-normal (\code{halfnorm}),
\item Inverse gamma (\code{invgamma}),
\item Inverse Gaussian (\code{invgauss}),
\item t distribution with unknown location and scale and known DoF (\code{lst_k3}),
\item t distribution with unknown location and scale, linear predictor on the location,
and known DoF (\code{lst_p1k3}),
\item Logistic (\code{logis}),
\item Logistic with linear predictor on the location (\code{logis_p1}),
\item Log-normal (\code{lnorm}),
\item Log-normal with linear predictor on the location (\code{lnorm_p1}),
\item Normal (\code{norm}),
\item Normal with linear predictor on the mean (\code{norm_p1}),
\item Pareto with known scale (\code{pareto_k2}),
\item Pareto with log-linear predictor on the shape and known scale (\code{pareto_p1k2}),
\item Uniform (\code{unif}),
\item Weibull (\code{weibull}),
\item Weibull with linear predictor on the scale (\code{weibull_p2}),
}

The level of predictive probability matching achieved
by the maximum likelihood and calibrating prior quantiles, for any model,
sample size and true parameter values, can be demonstrated using the
routine \code{reltest}.

Model selection among models can be demonstrated using the routines
\code{ms_flat_1tail},
\code{ms_flat_2tail},
\code{ms_predictors_1tail},
and \code{ms_predictors_2tail},
}
\author{
Stephen Jewson \email{stephen.jewson@gmail.com}
}
