% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compounding-class.R
\name{compounding}
\alias{compounding}
\title{Create Compounding class}
\usage{
compounding(x = c("simple", "discrete", "continuous"))
}
\arguments{
\item{x}{a character with the name of compounding regime:
\code{simple}, \code{discrete}, \code{continuous}}
}
\value{
A subclass of \code{Compounding} object.
}
\description{
\code{compound()} creates a \code{Compounding} object in one of its subclasses:
\linkS4class{Simple}, \linkS4class{Discrete}, \linkS4class{Continuous}.
}
\details{
A Compounding object can be instanciated with the \code{compounding}
function, passing a string with the name of one of the compounding regimes:
\code{simple}, \code{discrete}, \code{continuous}.
}
\examples{
compounding("simple")
compounding("discrete")
compounding("continuous")

comp <- compounding("discrete")
compound(comp, 0.06, 2) # equals (1 + 0.06) ^ 2 = 1.1236
rates(comp, 1.1236, 2) # equals 0.06
}
