## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(fixedincome)

crv <- spotratecurve(
  c(0.1315, 0.1319, 0.1338, 0.1348, 0.1372, 0.1381),
  c(1, 21, 42, 63, 126, 252),
  "discrete", "business/252", "Brazil/ANBIMA",
  refdate = Sys.Date()
)

## -----------------------------------------------------------------------------
crv[c(1, 3, 5)]

## -----------------------------------------------------------------------------
crv[crv > 0.135]

## -----------------------------------------------------------------------------
crv[(crv@terms %% 2) == 0]

## -----------------------------------------------------------------------------
crv[[c(1, 21, 42)]]

## -----------------------------------------------------------------------------
crv[[c(1, 13, 42)]]

## -----------------------------------------------------------------------------
interpolation(crv) <- interp_linear()
crv[[c(1, 13, 42)]]

## -----------------------------------------------------------------------------
interpolation(crv) <- NULL

## -----------------------------------------------------------------------------
crv[2] <- 0.14
crv[c(1, 2, 3)]

## -----------------------------------------------------------------------------
crv[-2]

## -----------------------------------------------------------------------------
crv

## -----------------------------------------------------------------------------
crv[[21]] <- 0.1320
crv[[c(1, 21, 42)]]

## -----------------------------------------------------------------------------
crv[[-21]]

## ----error=TRUE---------------------------------------------------------------
interpolation(crv) <- interp_linear()
crv[[-21]]

## -----------------------------------------------------------------------------
fixedincome::first(crv, "50 days")

## -----------------------------------------------------------------------------
fixedincome::last(crv, "6 months")

## -----------------------------------------------------------------------------
fixedincome::closest(crv, "1 year")

