% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-methods.R
\name{plotHistTrace}
\alias{plotHistTrace}
\title{Generate Histogram and Trace Plots for MCMC Samples}
\usage{
plotHistTrace(
  results,
  variables = NULL,
  sample_type = "fitted",
  effect_type = "treatment_effect",
  plot_type = "cred",
  aux_vars = list(),
  facet_by = NULL
)
}
\arguments{
\item{results}{A fitted model object from \code{rjMCMC}.}

\item{variables}{A vector of variable names to include in the plot, representing the estimand or covariates of interest.}

\item{sample_type}{Character string specifying the sample type: \code{"estimand"}, \code{"fitted"}, or \code{"predictive"}.
When set to \code{"estimand"}, the function plots individual parameters from the posterior.
For \code{"fitted"} or \code{"predictive"}, it uses posterior samples for one individual’s
fitted or predictive values.}

\item{plot_type}{Character string specifying the plot type: \code{"hist"} for histogram or \code{"trace"} for trace plots.
\code{"hist"} shows the distribution of parameter values, while \code{"trace"} displays MCMC sampling trajectories.}

\item{aux_vars}{A list of auxiliary variables and their values. Used to generate data for \code{fitted} or \code{predictive} values.
Each element name should correspond to a model variable.}

\item{facet_by}{A vector of variable names to facet by in the plot. Automatically set to binary model variables if \code{NULL}.}
}
\value{
A \code{ggplot2} object displaying histograms or trace plots of the MCMC samples.
}
\description{
This internal function creates histogram or trace plots for MCMC samples from an \code{rjMCMC} model,
displaying the posterior distributions or sampling trajectories of specified variables.
}
\details{
\itemize{
\item \strong{Sample and Plot Compatibility}:
\itemize{
\item For \code{sample_type = "estimand"}, only \code{plot_type = "hist"} or "trace" is compatible, as it represents the posterior
distribution or MCMC trajectory of individual parameters.
\item For \code{sample_type = "fitted"} or \code{"predictive"}, this function plots either the main effect
(no interaction with treatment) or treatment effect for an individual using auxiliary variable values.
}
\item \strong{Effect Types}:
\itemize{
\item For \code{sample_type = "fitted"} or \code{"predictive"}, \code{"outcome"} generates plots without treatment interaction,
and \code{"treatment_effect"} plots the interaction effect with treatment.
}
}
}
\note{
This is an internal function not intended for direct use by package users.
}
\keyword{internal}
