% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flair_lines.R
\name{flair_lines}
\alias{flair_lines}
\alias{flair_lines.default}
\title{Adds decorative formatting (flair) to parts of a string or source code,
specified by line(s).}
\usage{
flair_lines(x, lines)

\method{flair_lines}{default}(x, lines)
}
\arguments{
\item{x}{A string or \code{\link{with_flair}} object}

\item{lines}{Integer vector indicating which lines to apply the flair styling to.}
}
\value{
A string with formatting wrappers.
}
\description{
\code{flair_lines} returns a string with formatting wrappers(currently only
html), or applies the formatting to the source elements of a
\code{\link{with_flair}} object.
}
\examples{

code_string <- "x <- mean(1:10, na.rm = TRUE)
sqrt(x)" \%>\% flair_lines(2)

}
