% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emMixHMM.R
\name{emMixHMM}
\alias{emMixHMM}
\title{emMixHMM implemens the EM (Baum-Welch) algorithm to fit a mixture of HMM
models.}
\usage{
emMixHMM(Y, K, R, variance_type = c("heteroskedastic", "homoskedastic"),
  order_constraint = TRUE, init_kmeans = TRUE, n_tries = 1,
  max_iter = 1000, threshold = 1e-06, verbose = FALSE)
}
\arguments{
\item{Y}{Matrix of size \eqn{(n, m)} representing the observed
responses/outputs. \code{Y} consists of \emph{n} functions of \code{X} observed at
points \eqn{1,\dots,m}.}

\item{K}{The number of clusters (Number of HMM models).}

\item{R}{The number of regimes (HMM components) for each cluster.}

\item{variance_type}{Optional character indicating if the model is
"homoskedastic" or "heteroskedastic". By default the model is
"heteroskedastic".}

\item{order_constraint}{Optional. A logical indicating whether or not a mask
of order one should be applied to the transition matrix of the Markov chain
to provide ordered states. For the purpose of segmentation, it must be set
to \code{TRUE} (which is the default value).}

\item{init_kmeans}{Optional. A logical indicating whether or not the curve
partition should be initialized by the K-means algorithm. Otherwise the
curve partition is initialized randomly.}

\item{n_tries}{Optional. Number of runs of the EM algorithm. The solution
providing the highest log-likelihood will be returned.

If \code{n_tries} > 1, then for the first run, parameters are initialized by
uniformly segmenting the data into K segments, and for the next runs,
parameters are initialized by randomly segmenting the data into K
contiguous segments.}

\item{max_iter}{Optional. The maximum number of iterations for the EM
algorithm.}

\item{threshold}{Optional. A numeric value specifying the threshold for the
relative difference of log-likelihood between two steps of the EM as
stopping criteria.}

\item{verbose}{Optional. A logical value indicating whether or not values of
the log-likelihood should be printed during EM iterations.}
}
\value{
EM returns an object of class \link{ModelMixHMM}.
}
\description{
emMixHMM implements the maximum-likelihood parameter estimation of a mixture
of HMM models by the Expectation-Maximization (EM) algorithm, known as
Baum-Welch algorithm in the context of mixHMM.
}
\details{
emMixHMM function implements the EM algorithm. This function starts
with an initialization of the parameters done by the method \code{initParam} of
the class \link{ParamMixHMM}, then it alternates between the E-Step
(method of the class \link{StatMixHMM}) and the M-Step (method of
the class \link{ParamMixHMM}) until convergence (until the relative
variation of log-likelihood between two steps of the EM algorithm is less
than the \code{threshold} parameter).
}
\examples{
data(toydataset)
Y <- t(toydataset[,2:ncol(toydataset)])

mixhmm <- emMixHMM(Y = Y, K = 3, R = 3, verbose = TRUE)

mixhmm$summary()

mixhmm$plot()
}
\seealso{
\link{ModelMixHMM}, \link{ParamMixHMM}, \link{StatMixHMM}
}
