% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_light_profile.R
\name{plot.light_profile}
\alias{plot.light_profile}
\title{Visualize Profiles, e.g. of Partial Dependence}
\usage{
\method{plot}{light_profile}(
  x,
  swap_dim = FALSE,
  facet_scales = "free_x",
  rotate_x = x$type != "partial dependence",
  show_points = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{light_profile}.}

\item{swap_dim}{If multiflashlight and one "by" variable or single flashlight with two "by" variables, swap the role of dodge/fill variable and facet variable. If multiflashlight or one "by" variable, use facets instead of colors.}

\item{facet_scales}{Scales argument passed to \code{facet_wrap}.}

\item{rotate_x}{Should x axis labels be rotated by 45 degrees? TRUE, except for type "partial dependence".}

\item{show_points}{Should points be added to the line (default is \code{TRUE}).}

\item{...}{Further arguments passed to \code{geom_point} and \code{geom_line}.}
}
\value{
An object of class \code{ggplot2}.
}
\description{
Minimal visualization of an object of class \code{light_profile}. The object returned is of class \code{ggplot} and can be further customized.
}
\details{
Either lines and points are plotted (if stats = "mean") or quartile boxes. If there is a "by" variable or a multiflashlight, this first dimension is taken care by color (or if \code{swap_dim = TRUE} by facets). If there are two "by" variables or a multiflashlight with one "by" variable, the first "by" variable is visualized as color, the second one or the multiflashlight via facet (change with \code{swap_dim}).
}
\examples{
fit_full <- lm(Sepal.Length ~ ., data = iris)
fit_part <- lm(Sepal.Length ~ Petal.Length, data = iris)
mod_full <- flashlight(model = fit_full, label = "full", data = iris, y = "Sepal.Length")
mod_part <- flashlight(model = fit_part, label = "part", data = iris, y = "Sepal.Length")
mods <- multiflashlight(list(mod_full, mod_part))

plot(light_profile(mod_full, v = "Species"))
plot(light_profile(mod_full, v = "Species", type = "residual", stats = "quartiles"))
plot(light_profile(mod_full, v = "Petal.Width", by = "Species"))
plot(light_profile(mods, v = "Petal.Width", by = "Species"))
}
\seealso{
\code{\link{light_profile}}, \code{\link{plot.light_effects}}.
}
