% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flashcard.R
\name{flashcard}
\alias{flashcard}
\title{Create flashcards}
\usage{
flashcard(
  x,
  termsfirst = TRUE,
  package = TRUE,
  theme = "moon",
  file = NULL,
  fontsize = "default",
  fontcolor = NULL,
  linkcolor = NULL,
  use_browser = FALSE
)
}
\arguments{
\item{x}{Name of pre-existing flashcard deck or path and name of CSV file
containing terms and descriptions}

\item{termsfirst}{Logical indicating whether to show terms first (TRUE) or
descriptions first (FALSE)}

\item{package}{Logical indicating whether to include package name in term}

\item{theme}{Name of reveal.js theme to use for flashcards}

\item{file}{Path and file name used to save flashcard deck locally (must
save as HTML)}

\item{fontsize}{Base font size for presentation. Acceptable values include
"default" (500\%), "large" (700\%), and "small" (300\%). Custom values can be
set as percentages (e.g., "250\%").}

\item{fontcolor}{Font color for non-link text.  Can be R color name, HTML
color name, or hex code.}

\item{linkcolor}{Font color for link text.  Can be R color name, HTML
color name, or hex code.}

\item{use_browser}{Logical indicating whether to show the presentation in the
RStudio viewer when available (FALSE) or the system's default browser (TRUE)}
}
\value{
An HTML file of terms and descriptions rendered in the RStudio viewer or
web browser.
}
\description{
The \code{flashcard()} function generates a set of flashcards with randomly
ordered pairs of terms and descriptions from built-in flashcard decks.
The function outputs reveal.js presentation as an HTML file.
If running in RStudio, the flashcards are output to the viewer.
Otherwise, they are output to a web browser.
}
\examples{
\donttest{
# Display terms then descriptions
flashcard("data_types")

# Display descriptions then terms
flashcard("data_types", termsfirst = FALSE)
}
}
\seealso{
Other functions for creating decks: 
\code{\link{create_deck}()}
}
\concept{functions for creating decks}
