% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_predict.R
\name{ff}
\alias{ff}
\title{Function for point estimation}
\usage{
ff(params, x_new, curve, fixed_params = NA)
}
\arguments{
\item{params}{A vector of parameter values.}

\item{x_new}{A vector of x values to evaluate the function.}

\item{curve}{A string. The name of the function used for curve fitting.}

\item{fixed_params}{A vector of fixed parameter values. NA by default.}
}
\value{
A vector of the evaluated values.
}
\description{
Function for point estimation
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_lin_plat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = c(15, 2, 45)
  )
print(mod_1)
# Point Prediction
predict(mod_1, x = 45, type = "point", id = 2)
}
\keyword{internal}
