% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.OR.R
\name{plot.OR}
\alias{plot.OR}
\title{plot.OR: Plot Smooth Odds Ratios}
\usage{
\method{plot}{OR}(
  x,
  predictor,
  prob = NULL,
  ref.value = NULL,
  conf.level = 0.95,
  round.x = NULL,
  ref.label = NULL,
  col,
  col.area,
  main,
  xlab,
  ylab,
  lty,
  xlim,
  ylim,
  xx,
  ylog = TRUE,
  log = ifelse(ylog, "", "y"),
  ...
)
}
\arguments{
\item{x}{An object of class "OR" generated by the \code{\link{flexOR}} function.}

\item{predictor}{The name of the predictor variable for which to plot the smooth odds ratios.}

\item{prob}{The probability level for the confidence interval. Default is NULL.}

\item{ref.value}{The predicted value at which to calculate the smooth odds ratios. Default is NULL.}

\item{conf.level}{The confidence level for the intervals. Default is 0.95.}

\item{round.x}{The number of decimal places to round the predictor variable values. Default is NULL.}

\item{ref.label}{The label for the reference value of the predictor variable. Default is NULL.}

\item{col}{Vector of colors for plotting. Default is c("black", "black", "grey85").}

\item{col.area}{Vector of colors for the confidence intervals.}

\item{main}{The title of the plot. Default is generated based on the predictor variable.}

\item{xlab}{Label for the x-axis. Default is the name of the predictor variable.}

\item{ylab}{Label for the y-axis. Default is "Ln OR(Z,Zref)" if logarithmic scale is used, else "OR(Z,Zref)".}

\item{lty}{Vector of line types for plotting. Default is c(1, 3).}

\item{xlim}{Range of the x-axis. Default is NULL.}

\item{ylim}{Range of the y-axis. Default is NULL.}

\item{xx}{Values for tick marks on the x-axis. Default is NULL.}

\item{ylog}{Logical. If TRUE, y-axis is on a logarithmic scale. Default is TRUE.}

\item{log}{Use a logarithmic scale for the y-axis (alternative argument name).}

\item{...}{Additional arguments passed to plotting functions.}
}
\value{
This function doesn't return a value. It is used for generating a plot.
}
\description{
Plots smooth odds ratios along with confidence intervals for a specified predictor.
}
\examples{
library(gam);

# Load dataset
data(PimaIndiansDiabetes2, package="mlbench");

mod1 <- flexOR(
  data=PimaIndiansDiabetes2,
  response="diabetes",
  formula=~s(age, 3.3) + s(mass, 4.1) + pedigree
);


}
\keyword{hplot}
\keyword{methods}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
