% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_apply.R
\name{wb_add_flextable}
\alias{wb_add_flextable}
\title{Adds a flextable to an openxlsx2 workbook sheet}
\usage{
wb_add_flextable(
  wb,
  sheet,
  ft,
  start_col = 1,
  start_row = 1,
  offset_caption_rows = 0L,
  dims = NULL
)
}
\arguments{
\item{wb}{an openxlsx2 workbook}

\item{sheet}{an openxlsx2 workbook sheet}

\item{ft}{a flextable}

\item{start_col}{a vector specifying the starting column to write to.}

\item{start_row}{a vector specifying the starting row to write to.}

\item{offset_caption_rows}{number of rows to offset the caption by}

\item{dims}{Spreadsheet dimensions that will determine start_col and start_row: "A1", "A1:B2", "A:B"}
}
\value{
an openxlsx2 workbook
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{

if(requireNamespace("flextable", quietly = TRUE)) {
  # Create a flextable
  ft <- flextable::as_flextable(table(mtcars[,c("am","cyl")]))

  # Create a workbook
  wb <- openxlsx2::wb_workbook()$add_worksheet("mtcars")

  # Add flextable to workbook
  wb <- wb_add_flextable(wb, "mtcars", ft)

  # Workbook can now be saved wb$save(),
  # opened wb$open() - or removed
  rm(wb)
 }

}
