% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_surrogates.R
\name{get_surrogates}
\alias{get_surrogates}
\title{Find Theta Surrogates}
\usage{
get_surrogates(dat)
}
\arguments{
\item{dat}{Matrix of binary item responses.}
}
\value{
Vector of surrogate theta values.
}
\description{
Compute surrogate theta values as the set of normalized first
principal component scores.
}
\details{
Compute surrogate theta values as the
normalized first principal component scores.
}
\examples{

set.seed(2342)
bmat <- sim_bmat(n_items = 5, k = 2)$bmat

theta <- rnorm(50)
dat <- sim_data(bmat = bmat, theta = theta)

tsur <- get_surrogates(dat)

}
\references{
Liang, L., & Browne, M. W. (2015). A quasi-parametric method for
fitting flexible item response functions. \emph{Journal of Educational and
Behavioral Statistics}, \emph{40}, 5--34. \doi{10.3102/1076998614556816}
}
