% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.flexsurvmix.R
\name{ajfit_flexsurvmix}
\alias{ajfit_flexsurvmix}
\title{Forms a tidy data frame for plotting the fit of parametric mixture
multi-state models against nonparametric estimates}
\usage{
ajfit_flexsurvmix(x, maxt = NULL, startname = "Start", B = NULL)
}
\arguments{
\item{x}{Fitted model returned by \code{\link{flexsurvmix}}.}

\item{maxt}{Maximum time to produce parametric estimates for.  By default
this is the maximum event time in the data, the maximum time we have
nonparametric estimates for.}

\item{startname}{Label to give the state corresponding to "no event happened
yet".  By default this is \code{"Start"}.}

\item{B}{Number of simulation replications to use to calculate a confidence
interval for the parametric estimates in \code{\link{p_flexsurvmix}}. 
Comparable intervals for the Aalen-Johansen estimates are returned if this
is set.  Otherwise if \code{B=NULL} then no intervals are returned.}
}
\description{
This computes Aalen-Johansen estimates of the probability of occupying each
state at a series of times, using \code{\link{ajfit}}. The equivalent
estimates from the parametric model are then produced using
\code{\link{p_flexsurvmix}}, and concatenated with the nonparametric
estimates to form a tidy data frame. This data frame can then simply be
plotted using \code{\link[ggplot2]{ggplot}}.
}
