% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_image}
\alias{as_image}
\title{image wrapper}
\usage{
as_image(x, src, width = 1, height = 0.2)
}
\arguments{
\item{x}{image will be repeated while iterating this variable. The variable should be
one of the original data frame. Note its values are not used, only its size.}

\item{src}{image filename}

\item{width, height}{size of the png file in inches}
}
\description{
The function has to be used with function display().
It lets add images within flextable.
}
\examples{
library(officer)
img.file <- file.path( R.home("doc"), "html", "logo.jpg" )
myft <- flextable(head( mtcars, n = 10))
myft <- display(myft,
    i = ~ qsec > 18, col_key = "qsec", pattern = "{{r_logo}}",
    formatters = list( r_logo ~ as_image(qsec,
      src = img.file, width = .20, height = .15)),
    fprops = list(qsec = fp_text(color = "orange")) )
myft
}
\seealso{
\code{\link{display}}
}
