% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{as_chunk}
\alias{as_chunk}
\title{chunk of text wrapper}
\usage{
as_chunk(x, props = NULL, formater = format_fun, ...)
}
\arguments{
\item{x}{text or any element that can be formatted as text
with function provided in argument \code{formater}.}

\item{props}{an \code{\link[officer]{fp_text}} object to be used to format the text.
If not specified, it will be the default value corresponding to the cell.}

\item{formater}{a function that will format x as a character vector.}

\item{...}{additional arguments for \code{formater} function.}
}
\description{
The function lets add text within flextable
objects with function \code{\link{compose}}.
It should be used inside a call to \code{\link{as_paragraph}}.
}
\examples{
library(officer)

myft <- flextable( head(iris))

myft <- compose( myft, j = "Sepal.Length",
 value = as_paragraph(
   "Sepal.Length value is ",
   as_chunk(Sepal.Length, props = fp_text(color = "red"))
 ),
 part = "body")
myft <- color(myft, color = "gray40", part = "all")
autofit(myft)
}
\seealso{
Other chunk elements for paragraph: \code{\link{as_bracket}},
  \code{\link{as_b}}, \code{\link{as_image}},
  \code{\link{as_i}}, \code{\link{as_sub}},
  \code{\link{as_sup}}, \code{\link{hyperlink_text}},
  \code{\link{linerange}}, \code{\link{lollipop}},
  \code{\link{minibar}}
}
\concept{chunk elements for paragraph}
