% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{empty_blanks}
\alias{empty_blanks}
\title{make blank columns as transparent}
\usage{
empty_blanks(x)
}
\arguments{
\item{x}{a flextable object}
}
\description{
blank columns are set as transparent. This is a shortcut function
that will delete top and bottom borders, change background color to
transparent and display empty content.
}
\examples{
typology <- data.frame(
  col_keys = c( "Sepal.Length", "Sepal.Width", "Petal.Length",
                "Petal.Width", "Species" ),
  what = c("Sepal", "Sepal", "Petal", "Petal", " "),
  measure = c("Length", "Width", "Length", "Width", "Species"),
  stringsAsFactors = FALSE )
typology

ft <- flextable(head(iris), col_keys = c("Species",
  "break1", "Sepal.Length", "Sepal.Width",
  "break2", "Petal.Length", "Petal.Width") )
ft <- set_header_df(ft, mapping = typology, key = "col_keys" )
ft <- merge_h(ft, part = "header")
ft <- theme_vanilla(ft)
ft <- empty_blanks(ft)
ft <- width(ft, j = c(2, 5), width = .1 )
ft
}
\seealso{
Other sugar functions for table style: \code{\link{align}},
  \code{\link{bg}}, \code{\link{bold}},
  \code{\link{color}}, \code{\link{fontsize}},
  \code{\link{font}}, \code{\link{italic}},
  \code{\link{padding}}, \code{\link{rotate}},
  \code{\link{valign}}
}
\concept{sugar functions for table style}
