% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{knit_print.flextable}
\alias{knit_print.flextable}
\title{Render flextable in rmarkdown}
\usage{
\method{knit_print}{flextable}(x, ...)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{...}{further arguments, not used.}
}
\description{
Function used to render flextable in knitr/rmarkdown documents.
HTML, Word and PowerPoint outputs are supported.

Function \code{htmltools_value} return an HTML version of the flextable,
this function is to be used within Shiny applications with \code{renderUI()}.
}
\note{
For Word (docx) output, if pandoc version >= 2.0 is used, a raw XML block
with the table code will be inserted. If pandoc version < 2.0 is used, an
error will be raised. Insertion of images is not supported
with rmarkdown for Word documents (use the package officedown instead).
For PowerPoint (pptx) output, if pandoc version < 2.4 is used, an error
will be raised.
}
\section{HTML chunk options}{

Result can be aligned with chunk option \code{ft.align} that
accepts values 'left', 'center' and 'right'.
}

\section{Word chunk options}{

Result can be aligned with chunk option \code{ft.align} that
accepts values 'left', 'center' and 'right'.

Word option 'Allow row to break across pages' can be
activated with chunk option \code{ft.split} set to TRUE.

To specify a Word style for table caption use chunk option
\code{tab.cap.style}. The default value is "Table Caption".
}

\section{PowerPoint chunk options}{

Position should be defined with options \code{ft.left}
and \code{ft.top}. Theses are the top left coordinates
of the placeholder that will contain the table. They
default to \code{{r ft.left=1, ft.left=2}}.
}

\section{PDF chunk options}{


Using flextable with template `pdf_document` is OK if the
flextable fits on one single page. The PDF output is not
a real latex output but a PNG image generated with package
'webshot' or package 'webshot2'. Package 'webshot2' should
be prefered as 'webshot' can have issues with some properties
(i.e. bold are not rendered for some users).

To specify usage of 'webshot2', use chunk option `webshot="webshot2"`.
}

\seealso{
Other flextable print function: \code{\link{as_raster}},
  \code{\link{docx_value}}, \code{\link{format.flextable}},
  \code{\link{htmltools_value}},
  \code{\link{plot.flextable}},
  \code{\link{print.flextable}},
  \code{\link{save_as_html}}, \code{\link{save_as_image}}
}
\author{
Maxim Nazarov
}
\concept{flextable print function}
