% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{print.flextable}
\alias{print.flextable}
\title{flextable printing}
\usage{
\method{print}{flextable}(x, preview = "html", ...)
}
\arguments{
\item{x}{flextable object}

\item{preview}{preview type, one of c("html", "pptx", "docx", "pdf, "log").
When \code{"log"} is used, a description of the flextable is printed.}

\item{...}{arguments for 'pdf_document' call when preview is "pdf".}
}
\description{
print a flextable object to format \code{html}, \code{docx},
\code{pptx} or as text (not for display but for informative purpose).
This function is to be used in an interactive context.
}
\note{
When argument \code{preview} is set to \code{"docx"} or \code{"pptx"}, an
external client linked to these formats (Office is installed) is used to
edit a document. The document is saved in the temporary directory of
the R session and will be removed when R session will be ended.

When argument \code{preview} is set to \code{"html"}, an
external client linked to these HTML format is used to display the table.
If RStudio is used, the Viewer is used to display the table.

Note also that a print method is used when flextable are used within
R markdown documents. See \code{\link[=knit_print.flextable]{knit_print.flextable()}}.
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()}
}
\concept{flextable print function}
