% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable.R
\name{flextable}
\alias{flextable}
\alias{qflextable}
\alias{regulartable}
\title{flextable creation}
\usage{
flextable(
  data,
  col_keys = names(data),
  cwidth = 0.75,
  cheight = 0.25,
  defaults = list(),
  theme_fun = theme_booktabs
)

qflextable(data)

regulartable(data, col_keys = names(data), cwidth = 0.75, cheight = 0.25)
}
\arguments{
\item{data}{dataset}

\item{col_keys}{columns names/keys to display. If some column names are not in
the dataset, they will be added as blank columns by default.}

\item{cwidth, cheight}{initial width and height to use for cell sizes in inches.}

\item{defaults, theme_fun}{deprecated, use \code{\link[=set_flextable_defaults]{set_flextable_defaults()}} instead.}
}
\description{
Create a flextable object with function \code{flextable}.

\code{flextable} are designed to make tabular reporting easier for
R users. Functions are available to let you format text, paragraphs and cells;
table cells can be merge vertically or horizontally, row headers can easilly
be defined, rows heights and columns widths can be manually set or automatically
computed.

Default formatting properties are automatically applied to every
flextable you produce. You can change these default values with
function \code{\link[=set_flextable_defaults]{set_flextable_defaults()}}.
}
\details{
A \code{flextable} is made of 3 parts: header, body and footer.

Most functions have an argument named \code{part} that will be used
to specify what part of of the table should be modified.
}
\note{
Function \code{regulartable} is maintained for compatibility with old codes
mades by users but be aware it produces the same exact object than \code{flextable}.
This function should be deprecated then removed in the next versions.
}
\section{Illustrations}{


\if{html}{\figure{fig_flextable_1.png}{options: width=100\%}}
}

\section{qflextable}{

\code{qflextable} is a convenient tool to produce quickly
a flextable for reporting where layoout is fixed and columns
widths adjusted with \code{\link[=autofit]{autofit()}}.
}

\examples{
ft <- flextable(head(mtcars))
ft
}
\seealso{
\code{\link[=style]{style()}}, \code{\link[=autofit]{autofit()}}, \code{\link[=theme_booktabs]{theme_booktabs()}}, \code{\link[=knit_print.flextable]{knit_print.flextable()}},
\code{\link[=compose]{compose()}}, \code{\link[=footnote]{footnote()}}, \code{\link[=set_caption]{set_caption()}}
}
