% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{save_as_image}
\alias{save_as_image}
\title{Save a flextable in an 'png' file}
\usage{
save_as_image(x, path, expand = 10, res = 200, ...)
}
\arguments{
\item{x}{a flextable object}

\item{path}{image file to be created. It should end with '.png'.}

\item{expand}{space in pixels to add around the table.}

\item{res}{The resolution of the device}

\item{...}{unused arguments}
}
\value{
a string containing the full name of the generated file
}
\description{
Save a flextable as a png image.
}
\examples{
library(gdtools)
register_liberationsans()
set_flextable_defaults(font.family = "Liberation Sans")

ft <- flextable(head(mtcars))
ft <- autofit(ft)
tf <- tempfile(fileext = ".png")
save_as_image(x = ft, path = tf)

init_flextable_defaults()
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_pptx}()},
\code{\link{save_as_rtf}()},
\code{\link{to_html.flextable}()}
}
\concept{flextable print function}
