% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizor.R
\name{fmt_signif_after_zeros}
\alias{fmt_signif_after_zeros}
\title{Format with significant figures after zeros}
\usage{
fmt_signif_after_zeros(x, digits = 3)
}
\arguments{
\item{x}{numeric values}

\item{digits}{number of digits displayed after the leading zeros}
}
\description{
Rounds significant figures after zeros in numeric vectors.
The number of digits displayed after the leading zeros is
customizable using the \code{digits} parameter.
}
\examples{
x <- data.frame(
  x = c(0.00000004567, 2.000003456, 3, pi)
)
ft_1 <- flextable(x)
ft_1 <- align(x = ft_1, j = 1, align = "left")
mk_par(ft_1, value = as_paragraph(
  fmt_signif_after_zeros(x)))
}
\seealso{
\code{\link[=tabulator]{tabulator()}}, \code{\link[=mk_par]{mk_par()}}

Other text formatter functions: 
\code{\link{fmt_2stats}()},
\code{\link{fmt_avg_dev}()},
\code{\link{fmt_dbl}()},
\code{\link{fmt_header_n}()},
\code{\link{fmt_int}()},
\code{\link{fmt_n_percent}()},
\code{\link{fmt_pct}()}
}
\concept{text formatter functions}
